<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require __DIR__ . '/../vendor/autoload.php';
use Minishlink\WebPush\WebPush;
use Minishlink\WebPush\Subscription;

// here I'll get the subscription endpoint in the POST parameters
// but in reality, you'll get this information in your database
// because you already stored it (cf. push_subscription.php)

$dataConnection = array('endpoint' => 'https://fcm.googleapis.com/fcm/send/fLw5zPRNbX4:APA91bHhdRmUtF8gGZfgQG_3hS5pJobvLbLHSSU1RED8B5jq9dEyXzfBQp9H_Bx72NoYcqtthW14PcZVC01OkVJBAE67y4-x0m90UkGt0vEdY9g-J7BQCgLHC3-fU7q_6_7ETmtDGhOT',
    'expirationTime' => '',
    'keys' => array(
            'p256dh' => 'BBn15VmLL6s2juGM_QtGwHe-wExqfWx62VK_PXSNoHmLyHWn9f5oNRvm4J7wQ3qeAkFVe-cTuZtYHpym2iE6cP0',
            'auth' => 'S20OW8GEM-_P4T4LvK76Jg'
        ),
    'contentEncoding' => 'aes128gcm'
);

$subscription = Subscription::create($dataConnection);

$auth = array(
    'VAPID' => array(
        'subject' => 'https://github.com/Minishlink/web-push-php-example/',
        'publicKey' => file_get_contents(__DIR__ . '/../keys/public_key.txt'), // don't forget that your public key also lives in app.js
        'privateKey' => file_get_contents(__DIR__ . '/../keys/private_key.txt'), // in the real world, this would be in a secret file
    ),
);

$webPush = new WebPush($auth);

$report = $webPush->sendOneNotification(
    $subscription,
    '{"message":"Hello! 👋"}',
);

// handle eventual errors here, and remove the subscription from your server if it is expired
$endpoint = $report->getRequest()->getUri()->__toString();

if ($report->isSuccess()) {
    echo "[v] Message sent successfully for subscription {$endpoint}.";
} else {
    echo "[x] Message failed to sent for subscription {$endpoint}: {$report->getReason()}";
}
